<?php
 
$dataPoints = array( 
	array('y' => 7,'label' => 'Nov 26' ),
	array('y' => 12,'label' => 'Nov 27' ),
	array('y' => 28,'label' => 'Nov 28' ),
	array('y' => 18,'label' => 'Nov 29' ),
	array('y' => 23,'label' => 'Nov 30' ),
	array('y' => 15,'label' => 'Dec 01' ),
	array('y' => 18,'label' => 'Dec 02' ),
	array('y' => 41,'label' => 'Dec 03' )
);
 
?>
<!DOCTYPE HTML>
<html>
<head>
<script>
window.onload = function() {
 
var chart = new CanvasJS.Chart("chartContainer", {
	animationEnabled: true,
	title:{
		text: "Pengiriman Batu Bara"
	},
	axisY: {
		title: "Berat BB (kg)",
		includeZero: true,
		suffix:  "k"
	},
	data: [{
		type: "bar",
		yValueFormatString: "#,##0K",
		indexLabel: "{y}",
		indexLabelPlacement: "inside",
		indexLabelFontWeight: "bolder",
		indexLabelFontColor: "white",
		dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
	}]
});
chart.render();
 
}
</script>
</head>
<body>
	<div class="container">
		<div id="chartContainer" style="height: 370px; width: 100%;"></div>
		<script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
	</div>
</body>
</html> 