<?php
class Records {	
   
	private $recordsTable = 'listnamasupir';
	public $id;
    public $namasupir;
    public $alamat;
    public $dob;
	public $nohp;
	public $subjabatan;
	public $jabatan;
	public $dept;
	public $section;
	private $conn;

	public function __construct($db){
        $this->conn = $db;
    }	    
	
	public function listRecords(){
		$sqlQuery = "SELECT * FROM ".$this->recordsTable." ";
		if(!empty($_POST["search"]["value"]))
		{
			$sqlQuery .= 'where(id LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR namasupir LIKE "%'.$_POST["search"]["value"].'%" ';			
			$sqlQuery .= ' OR alamat LIKE "%'.$_POST["search"]["value"].'%" ';			
			$sqlQuery .= ' OR dob LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR nohp LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR subjabatan LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR jabatan LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR dept LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR section LIKE "%'.$_POST["search"]["value"].'%") ';			
		}
		
		if(!empty($_POST["order"])){
			$sqlQuery .= 'ORDER BY '.$_POST['order']['0']['column'].' '.$_POST['order']['0']['dir'].' ';
		} else {
			$sqlQuery .= 'ORDER BY id DESC ';
		}
		
		if($_POST["length"] != -1){
			$sqlQuery .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}
		
		$stmt = $this->conn->prepare($sqlQuery);
		$stmt->execute();
		$result = $stmt->get_result();	
		
		$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable);
		$stmtTotal->execute();
		$allResult = $stmtTotal->get_result();
		$allRecords = $allResult->num_rows;
		
		$displayRecords = $result->num_rows;
		$records = array();		
		while ($record = $result->fetch_assoc()) { 				
			$rows = array();			
			$rows[] = $record['id'];
			$rows[] = ucfirst($record['namasupir']);
			$rows[] = $record['alamat'];		
			$rows[] = $record['dob'];	
			$rows[] = $record['nohp'];
			$rows[] = $record['subjabatan'];					
			$rows[] = $record['jabatan'];					
			$rows[] = $record['dept'];					
			$rows[] = $record['section'];					
			$rows[] = '<button type="button" name="update" id="'.$record["id"].'" class="btn btn-warning btn-sm update">Edit</button>';
			$rows[] = '<button type="button" name="delete" id="'.$record["id"].'" class="btn btn-danger btn-sm delete" >Hapus</button>';
			$records[] = $rows;
		}

		$output = array(
			"draw"	=>	intval($_POST["draw"]),			
			"iTotalRecords"	=> 	$displayRecords,
			"iTotalDisplayRecords"	=>  $allRecords,
			"data"	=> 	$records
		);
		
		echo json_encode($output);
	}
	
	public function getRecord(){
		if($this->id) 
		{
			$sqlQuery = "
				SELECT * FROM ".$this->recordsTable." 
				WHERE id = ?";			
			$stmt = $this->conn->prepare($sqlQuery);
			$stmt->bind_param("i", $this->id);	
			$stmt->execute();
			$result = $stmt->get_result();
			$record = $result->fetch_assoc();
			echo json_encode($record);
		}
	}
	public function updateRecord(){

		if($this->id) 
		{
			$stmt = $this->conn->prepare("
			UPDATE ".$this->recordsTable." 
			SET namasupir= ?, alamat = ?, dob = ?, nohp = ?, subjabatan = ?, jabatan = ?, dept = ?, section = ?
			WHERE id = ?");
	 
			$this->id = htmlspecialchars(strip_tags($this->id));
			$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));
			$this->alamat = htmlspecialchars(strip_tags($this->alamat));
			$this->dob = htmlspecialchars(strip_tags($this->dob));
			$this->nohp = htmlspecialchars(strip_tags($this->nohp));
			$this->subjabatan = htmlspecialchars(strip_tags($this->subjabatan));
			$this->jabatan = htmlspecialchars(strip_tags($this->jabatan));
			$this->dept = htmlspecialchars(strip_tags($this->dept));
			$this->section = htmlspecialchars(strip_tags($this->section));

			$stmt->bind_param("ssssssssi", $this->namasupir, $this->alamat, $this->dob, $this->nohp, $this->subjabatan, $this->jabatan, $this->dept, $this->section, $this->id);
			
			if($stmt->execute()){
				return true;
			}
		}	
	}
	public function addRecord(){
		
		if($this->namasupir) {
			$stmt = $this->conn->prepare("
			INSERT INTO ".$this->recordsTable."(`namasupir`, `alamat`, `dob`, `nohp`, `subjabatan`, `jabatan`, `dept`, `section`)
			VALUES(?,?,?,?,?,?,?,?)");
		
			$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));
			$this->alamat = htmlspecialchars(strip_tags($this->alamat));
			$this->dob = htmlspecialchars(strip_tags($this->dob));
			$this->nohp = htmlspecialchars(strip_tags($this->nohp));
			$this->subjabatan = htmlspecialchars(strip_tags($this->subjabatan));
			$this->jabatan = htmlspecialchars(strip_tags($this->jabatan));
			$this->dept = htmlspecialchars(strip_tags($this->dept));
			$this->section = htmlspecialchars(strip_tags($this->section));

			//i represents an integer type
			//d represents an double type
			//s represents an string type including date
			//b represents an blob type
			$stmt->bind_param("ssssssss", $this->namasupir, $this->alamat, $this->dob, $this->nohp, $this->subjabatan, $this->jabatan, $this->dept, $this->section);

			if($stmt->execute()){
				return true;
			}		
		}
	}

	public function deleteRecord(){
		if($this->id) {			

			$stmt = $this->conn->prepare("
				DELETE FROM ".$this->recordsTable." 
				WHERE id = ?");

			$this->id = htmlspecialchars(strip_tags($this->id));

			$stmt->bind_param("i", $this->id);

			if($stmt->execute()){
				return true;
			}
		}
	}
}
?>