<?php
class Records {	
   
	private $recordsTable = ' ondeliverydt';

	public $no;
	public $nolambung;
	public $namasupir;	
	public $shiftno;
	public $namachecker;
	public $tanggalkeluar;
	public $jamkeluar;
	public $tujuan;
	public $jarak;
	public $tanggalmasuk;
	public $namapit;
	public $namablock;
	public $namaseam;
	public $tipebatu;
	public $keterangan;
	public $grouptipebatu;
	public $alatmuat;
	public $statusdelivery;
	public $penimbang1;
	public $penimbang2;
	public $beratkotor;
	public $jamtimbang1;
	public $beratdt;
	public $jamtimbang2;
	public $tahunonly;
	public $bulanonly;
	public $tanggalonly;
	public $beratbersih;
	public $lokasiunloading;
	public $kondisibatu;
	public $dopo;
	public $solar;
	public $notabbm;
	public $isisolar;
	public $tutupterpal;
	public $lokasiasal;

	private $conn;

	public function __construct($db){
        $this->conn = $db;
    }	    

	public function listRecords(){
   		session_start(); 

		$sqlQuery = "SELECT * FROM ".$this->recordsTable." ";
		if(!empty($_POST["search"]["value"]))
		{
			$sqlQuery .= 'where(no LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR nolambung LIKE "%'.$_POST["search"]["value"].'%" ';			
			$sqlQuery .= ' OR namasupir LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR namapit LIKE "%'.$_POST["search"]["value"].'%") ';			
		}

		if(!empty($_POST["order"])){
			$sqlQuery .= 'ORDER BY '.$_POST['order']['0']['column'].' '.$_POST['order']['0']['dir'].' ';
		} else {
			$sqlQuery .= 'ORDER BY no DESC ';
		}
		
		if($_POST["length"] != -1){
			$sqlQuery .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}
		
		$stmt = $this->conn->prepare($sqlQuery);
		$stmt->execute();
		$result = $stmt->get_result();	
		
		$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable);
		$stmtTotal->execute();
		$allResult = $stmtTotal->get_result();
		$allRecords = $allResult->num_rows;
		
		$displayRecords = $result->num_rows;
		$records = array();			
		while ($record = $result->fetch_assoc()) { 				
			$rows = array();	
			$rows[] = $record['no'];

			if (($_SESSION['userid'] == 'kadrichu@gmail.com') || ($_SESSION['userid'] == 'michael.w@rimaugroup.com') || ($_SESSION['userid'] == 'pamela.h@rimaugroup.com') || ($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'ciasihregina@gmail.com') || ($_SESSION['userid'] == 'nicaherliani1997@gmail.com'))
				$rows[] = '<button type="button" name="update" no="'.$record["no"].'" class="btn btn-warning btn-sm update">Edit</button>';
			else 
				$rows[] = '<button disabled type="button" name="update" no="'.$record["no"].'" class="btn btn-secondary btn-sm update">Edit</button>';

			if ($_SESSION['userid'] == 'kadrichu@gmail.com') $rows[] = '<button type="button" name="delete" no="'.$record["no"].'" class="btn btn-danger btn-sm delete" >Hapus</button>';
			else $rows[] = '<button disabled type="button" name="delete" no="'.$record["no"].'" class="btn btn-secondary btn-sm delete" >Hapus</button>';

			$rows[] = $record['nolambung'];
			$rows[] = $record['namasupir'];	
			$rows[] = $record['shiftno'];
			$rows[] = $record['namachecker'];
			$rows[] = $record['tanggalkeluar'];
			$rows[] = $record['jamkeluar'];
			$rows[] = $record['tujuan'];
			$rows[] = $record['jarak'];
			$rows[] = $record['tanggalmasuk'];
			$rows[] = $record['namapit'];
			$rows[] = $record['namablock'];
			$rows[] = $record['namaseam'];
			$rows[] = $record['tipebatu'];
			$rows[] = $record['keterangan'];
			$rows[] = $record['grouptipebatu'];
			$rows[] = $record['alatmuat'];
			$rows[] = $record['statusdelivery'];
			$rows[] = $record['penimbang1'];
			$rows[] = $record['penimbang2'];
			$rows[] = $record['beratkotor'];
			$rows[] = $record['jamtimbang1'];
			$rows[] = $record['beratdt'];
			$rows[] = $record['jamtimbang2'];
			$rows[] = $record['tahunonly'];
			$rows[] = $record['bulanonly'];
			$rows[] = $record['tanggalonly'];
			$rows[] = $record['beratbersih'];
			$rows[] = $record['lokasiunloading'];
			$rows[] = $record['kondisibatu'];
			$rows[] = $record['dopo'];
			$rows[] = $record['solar'];
			$rows[] = $record['notabbm'];
			$rows[] = $record['isisolar'];
			$rows[] = $record['tutupterpal'];
			$rows[] = $record['lokasiasal'];

			$records[] = $rows;
		}

		$output = array(
			"draw"	=>	intval($_POST["draw"]),			
			"iTotalRecords"	=> 	$displayRecords,
			"iTotalDisplayRecords"	=>  $allRecords,
			"data"	=> 	$records
		);
		
		echo json_encode($output);
	}
	
	public function getRecord(){
		if($this->no) 
		{
			$sqlQuery = "
				SELECT * FROM ".$this->recordsTable." 
				WHERE no = ?";			
			$stmt = $this->conn->prepare($sqlQuery);
			$stmt->bind_param("i", $this->no);	
			$stmt->execute();
			$result = $stmt->get_result();
			$record = $result->fetch_assoc();
			echo json_encode($record);
		}
	}

	public function updateRecord(){
		if($this->no) 
		{
   			session_start(); 
			if (($_SESSION['userid'] == 'kadrichu@gmail.com') || ($_SESSION['userid'] == 'michael.w@rimaugroup.com')  || ($_SESSION['userid'] == 'pamela.h@rimaugroup.com') || ($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'ciasihregina@gmail.com') || ($_SESSION['userid'] == 'nicaherliani1997@gmail.com'))
			{
				$stmt = $this->conn->prepare("
				UPDATE ".$this->recordsTable." 
				SET namasupir= ?  
				WHERE no = ?");

				//$this->no = htmlspecialchars(strip_tags($this->no));
				//$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));
				//$this->jabatan = htmlspecialchars(strip_tags($this->jabatan));
				//$this->tipekendaraan = htmlspecialchars(strip_tags($this->tipekendaraan));

				$this->no = htmlspecialchars(strip_tags($this->no));
				//$this->nolambung = htmlspecialchars(strip_tags($this->nolambung));
				$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));	
				//$this->shiftno = htmlspecialchars(strip_tags($this->shiftno));
				//$this->namachecker = htmlspecialchars(strip_tags($this->namachecker));
				//$this->tanggalkeluar = htmlspecialchars(strip_tags($this->tanggalkeluar));
				//$this->jamkeluar = htmlspecialchars(strip_tags($this->jamkeluar));
				//$this->tujuan = htmlspecialchars(strip_tags($this->tujuan));
				//$this->jarak = htmlspecialchars(strip_tags($this->jarak));
				//$this->tanggalmasuk = htmlspecialchars(strip_tags($this->tanggalmasuk));
				//$this->namapit = htmlspecialchars(strip_tags($this->namapit));
				//$this->namablock = htmlspecialchars(strip_tags($this->namablock));
				//$this->namaseam = htmlspecialchars(strip_tags($this->namaseam));
				//$this->tipebatu = htmlspecialchars(strip_tags($this->tipebatu));
				//$this->keterangan = htmlspecialchars(strip_tags($this->keterangan));
				//$this->grouptipebatu = htmlspecialchars(strip_tags($this->grouptipebatu));
				//$this->alatmuat = htmlspecialchars(strip_tags($this->alatmuat));
				//$this->statusdelivery = htmlspecialchars(strip_tags($this->statusdelivery));
				//$this->penimbang1 = htmlspecialchars(strip_tags($this->penimbang1));
				//$this->penimbang2 = htmlspecialchars(strip_tags($this->penimbang2));
				//$this->beratkotor = htmlspecialchars(strip_tags($this->beratkotor));
				//$this->jamtimbang1 = htmlspecialchars(strip_tags($this->jamtimbang1));
				//$this->beratdt = htmlspecialchars(strip_tags($this->beratdt));
				//$this->jamtimbang2 = htmlspecialchars(strip_tags($this->jamtimbang2));
				//$this->tahunonly = htmlspecialchars(strip_tags($this->tahunonly));
				//$this->bulanonly = htmlspecialchars(strip_tags($this->bulanonly));
				//$this->tanggalonly = htmlspecialchars(strip_tags($this->tanggalonly));
				//$this->beratbersih = htmlspecialchars(strip_tags($this->beratbersih));
				//$this->lokasiunloading = htmlspecialchars(strip_tags($this->lokasiunloading));
				//$this->kondisibatu = htmlspecialchars(strip_tags($this->kondisibatu));
				//$this->dopo = htmlspecialchars(strip_tags($this->dopo));
				//$this->solar = htmlspecialchars(strip_tags($this->solar));
				//$this->notabbm = htmlspecialchars(strip_tags($this->notabbm));
				//$this->isisolar = htmlspecialchars(strip_tags($this->isisolar));
				//$this->tutupterpal = htmlspecialchars(strip_tags($this->tutupterpal));
				//$this->lokasiasal = htmlspecialchars(strip_tags($this->lokasiasal));

				$stmt->bind_param("si", $this->namasupir, $this->no);

				if($stmt->execute()){
					return true;
				}
			}
		}	
	}

	public function addRecord(){
		if($this->nokendaraan) {
			$stmt = $this->conn->prepare("INSERT INTO ".$this->recordsTable."( `nolambung`, `namasupir`, `shiftno`, `namachecker`, `tanggalkeluar`, `jamkeluar`, `tujuan`, `jarak`, `tanggalmasuk`, `namapit`, `namablock`, `namaseam`, `tipebatu`, `keterangan`, `grouptipebatu`, `alatmuat`, `statusdelivery`, `penimbang1`, `penimbang2`, `beratkotor`, `jamtimbang1`, `beratdt`, `jamtimbang2`, `tahunonly`, `bulanonly`, `tanggalonly`, `beratbersih`, `lokasiunloading`, `kondisibatu`, `dopo`, `solar`, `notabbm`, `isisolar`, `tutupterpal`, `lokasiasal`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

			$this->nolambung = htmlspecialchars(strip_tags($this->nolambung));
			$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));	
			$this->shiftno = htmlspecialchars(strip_tags($this->shiftno));
			$this->namachecker = htmlspecialchars(strip_tags($this->namachecker));
			$this->tanggalkeluar = htmlspecialchars(strip_tags($this->tanggalkeluar));
			$this->jamkeluar = htmlspecialchars(strip_tags($this->jamkeluar));
			$this->tujuan = htmlspecialchars(strip_tags($this->tujuan));
			$this->jarak = htmlspecialchars(strip_tags($this->jarak));
			$this->tanggalmasuk = htmlspecialchars(strip_tags($this->tanggalmasuk));
			$this->namapit = htmlspecialchars(strip_tags($this->namapit));
			$this->namablock = htmlspecialchars(strip_tags($this->namablock));
			$this->namaseam = htmlspecialchars(strip_tags($this->namaseam));
			$this->tipebatu = htmlspecialchars(strip_tags($this->tipebatu));
			$this->keterangan = htmlspecialchars(strip_tags($this->keterangan));
			$this->grouptipebatu = htmlspecialchars(strip_tags($this->grouptipebatu));
			$this->alatmuat = htmlspecialchars(strip_tags($this->alatmuat));
			$this->statusdelivery = htmlspecialchars(strip_tags($this->statusdelivery));
			$this->penimbang1 = htmlspecialchars(strip_tags($this->penimbang1));
			$this->penimbang2 = htmlspecialchars(strip_tags($this->penimbang2));
			$this->beratkotor = htmlspecialchars(strip_tags($this->beratkotor));
			$this->jamtimbang1 = htmlspecialchars(strip_tags($this->jamtimbang1));
			$this->beratdt = htmlspecialchars(strip_tags($this->beratdt));
			$this->jamtimbang2 = htmlspecialchars(strip_tags($this->jamtimbang2));
			$this->tahunonly = htmlspecialchars(strip_tags($this->tahunonly));
			$this->bulanonly = htmlspecialchars(strip_tags($this->bulanonly));
			$this->tanggalonly = htmlspecialchars(strip_tags($this->tanggalonly));
			$this->beratbersih = htmlspecialchars(strip_tags($this->beratbersih));
			$this->lokasiunloading = htmlspecialchars(strip_tags($this->lokasiunloading));
			$this->kondisibatu = htmlspecialchars(strip_tags($this->kondisibatu));
			$this->dopo = htmlspecialchars(strip_tags($this->dopo));
			$this->solar = htmlspecialchars(strip_tags($this->solar));
			$this->notabbm = htmlspecialchars(strip_tags($this->notabbm));
			$this->isisolar = htmlspecialchars(strip_tags($this->isisolar));
			$this->tutupterpal = htmlspecialchars(strip_tags($this->tutupterpal));
			$this->lokasiasal = htmlspecialchars(strip_tags($this->lokasiasal));

			//i represents an integer type
			//d represents an double type
			//s represents an string type including date
			//b represents an blob type
			//$stmt->bind_param("sss", $this->namasupir, $this->jabatan, $this->tipekendaraan);

			$stmt->bind_param("sssssssisssssssssssisissssisssiisss", $this->nolambung, $this->namasupir, $this->shiftno, $this->namachecker, $this->tanggalkeluar, $this->jamkeluar, $this->tujuan, $this->jarak, $this->tanggalmasuk, $this->namapit, $this->namablock, $this->namaseam, $this->tipebatu, $this->keterangan, $this->grouptipebatu, $this->alatmuat, $this->statusdelivery, $this->penimbang1, $this->penimbang2, $this->beratkotor, $this->jamtimbang1, $this->beratdt, $this->jamtimbang2, $this->tahunonly, $this->bulanonly, $this->tanggalonly, $this->beratbersih, $this->lokasiunloading, $this->kondisibatu, $this->dopo, $this->solar, $this->notabbm, $this->isisolar, $this->tutupterpal, $this->lokasiasal);

			if($stmt->execute()){
				return true;
			}	
		}
	}

	public function deleteRecord(){
		if($this->no) {	
			session_start(); 
			if ($_SESSION['userid'] == 'kadrichu@gmail.com')
			{
				$stmt = $this->conn->prepare("
					DELETE FROM ".$this->recordsTable." 
					WHERE no = ?");

				$this->no = htmlspecialchars(strip_tags($this->no));

				$stmt->bind_param("i", $this->no);

				if($stmt->execute()){
					return true;
				}
			}
		}
	}
} 
?>