<?php
class Records {	
   
	private $recordsTable = 'listsupirDTR';
	public $no;
    public $namasupir;
	public $jabatan;
	public $tipekendaraan;
	private $conn;

	public function __construct($db){
        $this->conn = $db;
    }	    

	public function listRecords(){
		$sqlQuery = "SELECT * FROM ".$this->recordsTable." ";
		if(!empty($_POST["search"]["value"]))
		{
			$sqlQuery .= 'where(no LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR namasupir LIKE "%'.$_POST["search"]["value"].'%" ';			
			$sqlQuery .= ' OR jabatan LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR tipekendaraan LIKE "%'.$_POST["search"]["value"].'%") ';			
		}
		
		if(!empty($_POST["order"])){
			$sqlQuery .= 'ORDER BY '.$_POST['order']['0']['column'].' '.$_POST['order']['0']['dir'].' ';
		} else {
			$sqlQuery .= 'ORDER BY no DESC ';
		}
		
		if($_POST["length"] != -1){
			$sqlQuery .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}
		
		$stmt = $this->conn->prepare($sqlQuery);
		$stmt->execute();
		$result = $stmt->get_result();	
		
		$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable);
		$stmtTotal->execute();
		$allResult = $stmtTotal->get_result();
		$allRecords = $allResult->num_rows;
		
		$displayRecords = $result->num_rows;
		$records = array();		
		while ($record = $result->fetch_assoc()) { 				
			$rows = array();			
			$rows[] = $record['no'];
			$rows[] = ucfirst($record['namasupir']);
			$rows[] = $record['jabatan'];					
			$rows[] = $record['tipekendaraan'];					
			$rows[] = '<button type="button" name="update" no="'.$record["no"].'" class="btn btn-warning btn-sm update">Edit</button>';
			$rows[] = '<button type="button" name="delete" no="'.$record["no"].'" class="btn btn-danger btn-sm delete" >Hapus</button>';
			$records[] = $rows;
		}

		$output = array(
			"draw"	=>	intval($_POST["draw"]),			
			"iTotalRecords"	=> 	$displayRecords,
			"iTotalDisplayRecords"	=>  $allRecords,
			"data"	=> 	$records
		);
		
		echo json_encode($output);
	}
	
	public function getRecord(){
		if($this->no) 
		{
			$sqlQuery = "
				SELECT * FROM ".$this->recordsTable." 
				WHERE no = ?";			
			$stmt = $this->conn->prepare($sqlQuery);
			$stmt->bind_param("i", $this->no);	
			$stmt->execute();
			$result = $stmt->get_result();
			$record = $result->fetch_assoc();
			echo json_encode($record);
		}
	}
	public function updateRecord(){

		if($this->no) 
		{
			$stmt = $this->conn->prepare("
			UPDATE ".$this->recordsTable." 
			SET namasupir= ?, jabatan = ?, tipekendaraan = ?
			WHERE no = ?");
	 
			$this->no = htmlspecialchars(strip_tags($this->no));
			$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));
			$this->jabatan = htmlspecialchars(strip_tags($this->jabatan));
			$this->tipekendaraan = htmlspecialchars(strip_tags($this->tipekendaraan));

			$stmt->bind_param("sssi", $this->namasupir, $this->jabatan, $this->tipekendaraan, $this->no);
			
			if($stmt->execute()){
				return true;
			}
		}	
	}
	public function addRecord(){
		if($this->namasupir) {
			$stmt = $this->conn->prepare("
			INSERT INTO ".$this->recordsTable."(`namasupir`, `jabatan`, `tipekendaraan`)
			VALUES(?,?,?)");
		
			$this->namasupir = htmlspecialchars(strip_tags($this->namasupir));
			$this->jabatan = htmlspecialchars(strip_tags($this->jabatan));
			$this->tipekendaraan = htmlspecialchars(strip_tags($this->tipekendaraan));

			//i represents an integer type
			//d represents an double type
			//s represents an string type including date
			//b represents an blob type
			$stmt->bind_param("sss", $this->namasupir, $this->jabatan, $this->tipekendaraan);

			if($stmt->execute()){
				return true;
			}		
		}
	}

	public function deleteRecord(){
		if($this->no) {			

			$stmt = $this->conn->prepare("
				DELETE FROM ".$this->recordsTable." 
				WHERE no = ?");

			$this->no = htmlspecialchars(strip_tags($this->no));

			$stmt->bind_param("i", $this->no);

			if($stmt->execute()){
				return true;
			}
		}
	}
}
?>