<?php
class Records {	
   
	private $recordsTable = 'allvehicle';
	public $no;
    public $nokendaraan;
    public $merek;
    public $model;
	public $tipe;
	public $tahun;
	public $kelompok;
	public $pt;
	public $divisi;
	public $position;
	public $status;
	public $kodeunit;
	public $nomesin;
	public $norangka;
	public $keterangan;
	public $komsumsibbm;

	public $hm_terakhir;
	public $hm_last_pm;
	public $hm_last_OVH;
	public $hm_pm_Panduan;
	public $hm_OVH_Panduan;

	private $conn;

	public function __construct($db){
        $this->conn = $db;
    }	    
	
	public function listRecords(){
   		session_start(); 

		$sqlQuery = "SELECT * FROM ".$this->recordsTable." ";
		if(!empty($_POST["search"]["value"]))
		{
			$sqlQuery .= 'where(no LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR nokendaraan LIKE "%'.$_POST["search"]["value"].'%" ';			
			$sqlQuery .= ' OR merek LIKE "%'.$_POST["search"]["value"].'%" ';			
			$sqlQuery .= ' OR model LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR tipe LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR tahun LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR kelompok LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR pt LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR divisi LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR position LIKE "%'.$_POST["search"]["value"].'%" ';
			$sqlQuery .= ' OR status LIKE "%'.$_POST["search"]["value"].'%") ';			
			//$sqlQuery .= ' OR kodeunit LIKE "%'.$_POST["search"]["value"].'%") ';			
			//$sqlQuery .= ' OR nomesin LIKE "%'.$_POST["search"]["value"].'%") ';			
			//$sqlQuery .= ' OR norangka LIKE "%'.$_POST["search"]["value"].'%") ';			
			//$sqlQuery .= ' OR keterangan LIKE "%'.$_POST["search"]["value"].'%") ';			
		}
		
		if(!empty($_POST["order"])){
			$sqlQuery .= 'ORDER BY '.$_POST['order']['0']['column'].' '.$_POST['order']['0']['dir'].' ';
		} else {
			$sqlQuery .= 'ORDER BY no DESC ';
		}
		
		if($_POST["length"] != -1){
			$sqlQuery .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}
		
		$stmt = $this->conn->prepare($sqlQuery);
		$stmt->execute();
		$result = $stmt->get_result();	
		
		$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable);
		$stmtTotal->execute();
		$allResult = $stmtTotal->get_result();
		$allRecords = $allResult->num_rows;
		
		$displayRecords = $result->num_rows;
		$records = array();		
		while ($record = $result->fetch_assoc()) { 				
			$rows = array();
			$rows[] = $record['no'];

			if ($_SESSION['userid'] != 'deny.esa@rimaugroup.com')
			{
				$rows[] = '<button type="button" name="update" no="'.$record["no"].'" class="btn btn-warning btn-sm update">Edit</button>';
				$rows[] = '<button type="button" name="delete" no="'.$record["no"].'" class="btn btn-danger btn-sm delete" >Hapus</button>';
			}
			else
			{
				$rows[] = '<button disabled type="button" name="update" no="'.$record["no"].'" class="btn btn-secondary btn-sm update">Edit</button>';
				$rows[] = '<button disabled type="button" name="delete" no="'.$record["no"].'" class="btn btn-secondary btn-sm delete" >Hapus</button>';
			}

			$rows[] = ucfirst($record['nokendaraan']);
			$rows[] = $record['merek'];		
			$rows[] = $record['model'];	
			$rows[] = $record['tipe'];
			$rows[] = $record['tahun'];					
			$rows[] = $record['kelompok'];					
			$rows[] = $record['pt'];					
			$rows[] = $record['divisi'];					
			$rows[] = $record['position'];					
			$rows[] = $record['status'];		
			$rows[] = $record['kodeunit'];		
			$rows[] = $record['nomesin'];		
			$rows[] = $record['norangka'];		
			$rows[] = $record['keterangan'];		
			$rows[] = $record['komsumsibbm'];		
			$rows[] = $record['hm_terakhir'];		
			$rows[] = $record['hm_last_pm'];		
			$rows[] = $record['hm_last_OVH'];		
			$rows[] = $record['hm_pm_Panduan'];		
			$rows[] = $record['hm_OVH_Panduan'];		
			$records[] = $rows;
		}

		$output = array(
			"draw"	=>	intval($_POST["draw"]),			
			"iTotalRecords"	=> 	$displayRecords,
			"iTotalDisplayRecords"	=>  $allRecords,
			"data"	=> 	$records
		);
		
		echo json_encode($output);
	}
	
	public function getRecord(){
		if($this->no) 
		{
			$sqlQuery = "
				SELECT * FROM ".$this->recordsTable." 
				WHERE no = ?";			
			$stmt = $this->conn->prepare($sqlQuery);
			$stmt->bind_param("i", $this->no);	
			$stmt->execute();
			$result = $stmt->get_result();
			$record = $result->fetch_assoc();
			echo json_encode($record);
		}
	}
	public function updateRecord(){

		if($this->no) 
		{
   			session_start(); 
			if (($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'derel@rimauapps.com') || ($_SESSION['userid'] == 'michael.w@rimaugroup.com') || ($_SESSION['userid'] == 'kadrichu@gmail.com') || ($_SESSION['userid'] == 'ian.soit@rimaugroup.com'))
			{
				$stmt = $this->conn->prepare("
				UPDATE ".$this->recordsTable." 
				SET merek = ?, model = ?, tipe = ?, tahun = ?, kelompok = ?, pt = ?, divisi = ?, position = ?, status = ?, kodeunit = ?, nomesin = ?, norangka = ?, keterangan = ?, komsumsibbm = ?, hm_terakhir = ?, hm_last_pm = ?, hm_last_OVH = ?, hm_pm_Panduan = ?, hm_OVH_Panduan = ?
				WHERE no = ?");

				$this->no = htmlspecialchars(strip_tags($this->no));
				//no kendaraan nggak boleh dirubah ya
				//$this->nokendaraan = htmlspecialchars(strip_tags($this->nokendaraan));
				$this->merek = htmlspecialchars(strip_tags($this->merek));
				$this->model = htmlspecialchars(strip_tags($this->model));
				$this->tipe = htmlspecialchars(strip_tags($this->tipe));
				$this->tahun = htmlspecialchars(strip_tags($this->tahun));
				$this->kelompok = htmlspecialchars(strip_tags($this->kelompok));
				$this->pt = htmlspecialchars(strip_tags($this->pt));
				$this->divisi = htmlspecialchars(strip_tags($this->divisi));
				$this->position = htmlspecialchars(strip_tags($this->position));
				$this->status = htmlspecialchars(strip_tags($this->status));
				$this->kodeunit = htmlspecialchars(strip_tags($this->kodeunit));
				$this->nomesin = htmlspecialchars(strip_tags($this->nomesin));
				$this->norangka = htmlspecialchars(strip_tags($this->norangka));
				$this->keterangan = htmlspecialchars(strip_tags($this->keterangan));
				$this->komsumsibbm = htmlspecialchars(strip_tags($this->komsumsibbm));

				$this->hm_terakhir = htmlspecialchars(strip_tags($this->hm_terakhir));
				$this->hm_last_pm = htmlspecialchars(strip_tags($this->hm_last_pm));
				$this->hm_last_OVH = htmlspecialchars(strip_tags($this->hm_last_OVH));
				$this->hm_pm_Panduan = htmlspecialchars(strip_tags($this->hm_pm_Panduan));
				$this->hm_OVH_Panduan = htmlspecialchars(strip_tags($this->hm_OVH_Panduan));

				//i represents an integer type
				//d represents an double type
				//s represents an string type including date
				//b represents an blob type
				$stmt->bind_param("sssssssssssssiiiiiii",  $this->merek, $this->model, $this->tipe, $this->tahun, $this->kelompok, $this->pt, $this->divisi, $this->position, $this->status, $this->kodeunit, $this->nomesin, $this->norangka, $this->keterangan, $this->komsumsibbm, $this->hm_terakhir, $this->hm_last_pm, $this->hm_last_OVH, $this->hm_pm_Panduan, $this->hm_OVH_Panduan, $this->no);
			
				if($stmt->execute()){
					return true;
				}
			}
		}	
	}
	public function addRecord(){
		
		if($this->nokendaraan) 
		{
   			session_start(); 
			if (($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'derel@rimauapps.com') || ($_SESSION['userid'] == 'michael.w@rimaugroup.com') || ($_SESSION['userid'] == 'kadrichu@gmail.com') || ($_SESSION['userid'] == 'ian.soit@rimaugroup.com'))
			{
				$stmt = $this->conn->prepare("
				INSERT INTO ".$this->recordsTable."(`nokendaraan`, `merek`, `model`, `tipe`, `tahun`, `kelompok`, `pt`, `divisi`, `position`, `status`, `kodeunit`, `nomesin`, `norangka`, `keterangan`, `komsumsibbm`, `hm_terakhir`, `hm_last_pm`, `hm_last_OVH`, `hm_pm_Panduan`, `hm_OVH_Panduan`)
				VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

				$this->nokendaraan = htmlspecialchars(strip_tags($this->nokendaraan));
				$this->merek = htmlspecialchars(strip_tags($this->merek));
				$this->model = htmlspecialchars(strip_tags($this->model));
				$this->tipe = htmlspecialchars(strip_tags($this->tipe));
				$this->tahun = htmlspecialchars(strip_tags($this->tahun));
				$this->kelompok = htmlspecialchars(strip_tags($this->kelompok));
				$this->pt = htmlspecialchars(strip_tags($this->pt));
				$this->divisi = htmlspecialchars(strip_tags($this->divisi));
				$this->position = htmlspecialchars(strip_tags($this->position));
				$this->status = htmlspecialchars(strip_tags($this->status));
				$this->kodeunit = htmlspecialchars(strip_tags($this->kodeunit));
				$this->nomesin = htmlspecialchars(strip_tags($this->nomesin));
				$this->norangka = htmlspecialchars(strip_tags($this->norangka));
				$this->keterangan = htmlspecialchars(strip_tags($this->keterangan));
				$this->komsumsibbm = htmlspecialchars(strip_tags($this->komsumsibbm));
				$this->hm_terakhir = htmlspecialchars(strip_tags($this->hm_terakhir));
				$this->hm_last_pm = htmlspecialchars(strip_tags($this->hm_last_pm));
				$this->hm_last_OVH = htmlspecialchars(strip_tags($this->hm_last_OVH));
				$this->hm_pm_Panduan = htmlspecialchars(strip_tags($this->hm_pm_Panduan));
				$this->hm_OVH_Panduan = htmlspecialchars(strip_tags($this->hm_OVH_Panduan));

				//i represents an integer type
				//d represents an double type
				//s represents an string type including date
				//b represents an blob type
				$stmt->bind_param("ssssssssssssssiiiiii", $this->nokendaraan, $this->merek, $this->model, $this->tipe, $this->tahun, $this->kelompok, $this->pt, $this->divisi, $this->position, $this->status, $this->kodeunit, $this->nomesin, $this->norangka, $this->keterangan, $this->komsumsibbm, $this->hm_terakhir, $this->hm_last_pm, $this->hm_last_OVH, $this->hm_pm_Panduan, $this->hm_OVH_Panduan);

				if($stmt->execute()){
					return true;
				}
			}
		}
	}
 
	public function deleteRecord(){
		if($this->no) {
   			session_start(); 

			if ($_SESSION['userid'] == 'kadrichu@gmail.com')
			{
				$stmt = $this->conn->prepare("
					DELETE FROM ".$this->recordsTable." 
					WHERE no = ?");

				$this->no = htmlspecialchars(strip_tags($this->no));

				$stmt->bind_param("i", $this->no);

				if($stmt->execute()){
					return true;
				}
			}
		}
	}
}
?>