<?php
class Records {	
	private $recordsTable = "ws_sparepart_store ";

	public $no;
	public $wslocation;
	public $rackno;
	public $itemname;
	public $itemdesc;	
	public $itemcatagory;
	public $item_brand;
	public $item_model;
	public $partno;
	public $qty_now;
	public $part_unit;
	public $minstocklevel;
	public $costprice;
	public $saleprice;

	private $conn;

	public function __construct($db){
        $this->conn = $db;
    }	    
	public function listRecords(){

   		session_start(); 

	//	================================================================
	//	breakdown subperusahaan
	//	================================================================
		$xSub = $_SESSION['subperusahaan'];
		$listsubperusahaan	= explode(' ',trim($xSub));
		$numsubperusahaan	= count($listsubperusahaan);
		if ($numsubperusahaan == 1)
		{
			$string1	= "wslocation = '$xSub'";
		}
		else
		{
			$string1 = "(";
			for ($i=0; $i < $numsubperusahaan; $i++)
			{
				$string1	= $string1 . "wslocation = '$listsubperusahaan[$i]' OR ";
			}

			$string1 =  substr_replace($string1, "", -4);
			$string1 =   $string1 . ")";
		}
		//-------------------------------------------------------------//
		//-------------------------------------------------------------//
		if (($_SESSION['authority'] == 'managertambang') || ($_SESSION['subperusahaan'] == 'WSALL'))
		{
			$sqlQuery = "SELECT * FROM ".$this->recordsTable." ";
			//$sqlQuery = "SELECT * FROM ".$this->recordsTable." where (wslocation <> 'HRGA-P')";
		}
		else
			$sqlQuery = "SELECT * FROM ".$this->recordsTable." where ($string1) ";
		//-------------------------------------------------------------//
		//-------------------------------------------------------------//

		if(!empty($_POST["search"]["value"]))
		{
			if (($_SESSION['authority'] == 'managertambang') || ($_SESSION['subperusahaan'] == 'WSALL'))
			{
				$sqlQuery .= 'where(no LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR itemname LIKE "%'.$_POST["search"]["value"].'%" ';			
				$sqlQuery .= ' OR itemdesc LIKE "%'.$_POST["search"]["value"].'%" ';			
				$sqlQuery .= ' OR itemcatagory LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR item_brand LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR item_model LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR partno LIKE "%'.$_POST["search"]["value"].'%") ';	
			}
			else
			{
				$sqlQuery .= 'AND (no LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR itemname LIKE "%'.$_POST["search"]["value"].'%" ';			
				$sqlQuery .= ' OR itemdesc LIKE "%'.$_POST["search"]["value"].'%" ';			
				$sqlQuery .= ' OR itemcatagory LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR item_brand LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR item_model LIKE "%'.$_POST["search"]["value"].'%" ';
				$sqlQuery .= ' OR partno LIKE "%'.$_POST["search"]["value"].'%") ';
			}
		}
		
		if(!empty($_POST["order"])){
			$sqlQuery .= 'ORDER BY '.$_POST['order']['0']['column'].' '.$_POST['order']['0']['dir'].' ';
		} else {
			$sqlQuery .= 'ORDER BY no DESC ';
		}
		
		if($_POST["length"] != -1){
			$sqlQuery .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}
		
		$stmt = $this->conn->prepare($sqlQuery);
		$stmt->execute();
		$result = $stmt->get_result();	
		
		//-------------------------------------------------------------//
		//-------------------------------------------------------------//
		if (($_SESSION['authority'] == 'managertambang') || ($_SESSION['subperusahaan'] == 'WSALL'))
			$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable);
			//$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable." where (wslocation <> 'HRGA-P')");
		else
			$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable." where (" . $string1 . ') ');

		//$stmtTotal = $this->conn->prepare("SELECT * FROM ".$this->recordsTable);
		//-------------------------------------------------------------//
		//-------------------------------------------------------------//

		$stmtTotal->execute();
		$allResult	= $stmtTotal->get_result();
		$allRecords = $allResult->num_rows;
		
		$displayRecords = $result->num_rows;
		$records = array();

		while ($record = $result->fetch_assoc()) 
		{ 				
			$rows		= array();
			$rows[]		= $record['no'];
			
			if (($_SESSION['authority'] != 'ws_mekanik') && ($_SESSION['position'] != 'HEAD-MEKANIK'))
			{
				//if (($_SESSION['position'] != 'HEAD-LOGISTIK1') && ($_SESSION['position'] != 'HEAD-LOGISTIK2') && ($_SESSION['position'] != 'ACCOUNTING'))
				//{
					$rows[]		= '<button type="button" name="update" no="'.$record["no"].'" class="btn btn-warning btn-sm update">Edit</button>';
				//}
				//else
				//{
					//$rows[]		= '<button disabled type="button" name="update" no="'.$record["no"].'" class="btn btn-secondary btn-sm update">Edit</button>';
				//}


				if ($_SESSION['authority'] == 'managertambang')
				//if (($_SESSION['authority'] == 'managertambang') || ($_SESSION['authority'] == 'ws_gudang') ||  ($_SESSION['position'] == 'HEAD-LOGISTIK'))
				{
					$rows[]		= '<button type="button" name="delete" no="'.$record["no"].'" class="btn btn-danger btn-sm delete" >Hapus</button>';
				}
				else
				{
					$rows[]		= '<button disabled type="button" name="delete" no="'.$record["no"].'" class="btn btn-secondary btn-sm delete" >Hapus</button>';
				}
			}
			else
			{
				$rows[]		= '<button disabled type="button" name="update" no="'.$record["no"].'" class="btn btn-secondary btn-sm update">Edit</button>';
				$rows[]		= '<button disabled type="button" name="delete" no="'.$record["no"].'" class="btn btn-secondary btn-sm delete" >Hapus</button>';
			}

			$rows[]		= $record['wslocation'];
			$rows[]		= $record['rackno'];
			$rows[]		= $record['itemname'];
			$rows[]		= $record['itemdesc'];	
			$rows[]		= $record['itemcatagory'];
			$rows[]		= $record['item_brand'];					
			$rows[]		= $record['item_model'];					
			$rows[]		= $record['partno'];	
			$rows[]		= $record['qty_now'];				
			$rows[]		= $record['part_unit'];
			$rows[]		= $record['minstocklevel'];	
			$rows[]		= $record['costprice'];	
			$rows[]		= $record['saleprice'];	
			$records[]	= $rows;
		}

		$output = array(
			"draw"	=>	intval($_POST["draw"]),			
			"iTotalRecords"	=> 	$displayRecords,
			"iTotalDisplayRecords"	=>  $allRecords,
			"data"	=> 	$records
		);

		echo json_encode($output);
	}
	public function getRecord(){
		if($this->no) 
		{
			$sqlQuery = "
				SELECT * FROM ".$this->recordsTable." 
				WHERE no = ?";			
			$stmt = $this->conn->prepare($sqlQuery);
			$stmt->bind_param("i", $this->no);	
			$stmt->execute();
			$result = $stmt->get_result();
			$record = $result->fetch_assoc();
			echo json_encode($record);
		}
	}
	public function updateRecord(){
   		session_start(); 
		if($this->no) 
		{
			if (($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'kadrichu@gmail.com'))
				$stmt = $this->conn->prepare("UPDATE ".$this->recordsTable." SET wslocation= ?, rackno = ?,  itemname = ?, itemdesc = ?, itemcatagory = ?, item_brand = ?, item_model = ?, partno = ?, qty_now = ?, part_unit = ?, minstocklevel = ?, costprice = ?, saleprice = ?, editedby = ? WHERE no = ?");
			else
				$stmt = $this->conn->prepare("UPDATE ".$this->recordsTable." SET wslocation= ?, rackno = ?,  itemname = ?, itemdesc = ?, itemcatagory = ?, item_brand = ?, item_model = ?, part_unit = ?, minstocklevel = ?, costprice = ?, saleprice = ?, editedby = ? WHERE no = ?");

			$this->no				= htmlspecialchars(strip_tags($this->no));
			$this->wslocation		= htmlspecialchars(strip_tags($this->wslocation));
			$this->rackno			= htmlspecialchars(strip_tags($this->rackno));
			$this->itemname			= htmlspecialchars(strip_tags($this->itemname));
			$this->itemdesc			= htmlspecialchars(strip_tags($this->itemdesc));
			$this->itemcatagory		= htmlspecialchars(strip_tags($this->itemcatagory));
			$this->item_brand		= htmlspecialchars(strip_tags($this->item_brand));
			$this->item_model		= htmlspecialchars(strip_tags($this->item_model));


			//partno dan  qty_now nggak boleh dirubah ya
			if (($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'kadrichu@gmail.com'))
			{
				$this->partno		= htmlspecialchars(strip_tags($this->partno));
				$this->qty_now		= htmlspecialchars(strip_tags($this->qty_now));
			}

			$this->part_unit		= htmlspecialchars(strip_tags($this->part_unit));
			$this->minstocklevel	= htmlspecialchars(strip_tags($this->minstocklevel));
			$this->costprice		= htmlspecialchars(strip_tags($this->costprice));
			$this->saleprice		= htmlspecialchars(strip_tags($this->saleprice));
			$this->editedby			= htmlspecialchars(strip_tags($this->editedby));

			if (($_SESSION['userid'] == 'andresanta2496@gmail.com') || ($_SESSION['userid'] == 'kadrichu@gmail.com'))
				$stmt->bind_param("ssssssssisiiisi", $this->wslocation, $this->rackno, $this->itemname, $this->itemdesc, $this->itemcatagory, $this->item_brand, $this->item_model, $this->partno, $this->qty_now, $this->part_unit, $this->minstocklevel, $this->costprice, $this->saleprice, $this->editedby, $this->no);
			else
				$stmt->bind_param("ssssssssiiisi", $this->wslocation, $this->rackno, $this->itemname, $this->itemdesc, $this->itemcatagory, $this->item_brand, $this->item_model, $this->part_unit, $this->minstocklevel, $this->costprice, $this->saleprice, $this->editedby, $this->no);

			if($stmt->execute()){
				return true;
			}
		}	
	}
	public function addRecord(){
		
		if($this->partno) {
			$stmt = $this->conn->prepare("
			INSERT INTO ".$this->recordsTable."(`wslocation`, `rackno`, `itemname`, `itemdesc`, `itemcatagory`, `item_brand`, `item_model`, `partno`, `qty_now`, `part_unit`, `minstocklevel`, `costprice`, `saleprice`, `initial_qty`, `editedby`)
			VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		
			$this->wslocation		= htmlspecialchars(strip_tags($this->wslocation));
			$this->rackno			= htmlspecialchars(strip_tags($this->rackno));
			$this->itemname			= htmlspecialchars(strip_tags($this->itemname));
			$this->itemdesc			= htmlspecialchars(strip_tags($this->itemdesc));
			$this->itemcatagory		= htmlspecialchars(strip_tags($this->itemcatagory));
			$this->item_brand		= htmlspecialchars(strip_tags($this->item_brand));
			$this->item_model		= htmlspecialchars(strip_tags($this->item_model));
			$this->partno			= htmlspecialchars(strip_tags($this->partno));
			$this->qty_now			= htmlspecialchars(strip_tags($this->qty_now));
			$this->part_unit		= htmlspecialchars(strip_tags($this->part_unit));
			$this->minstocklevel	= htmlspecialchars(strip_tags($this->minstocklevel));
			$this->costprice		= htmlspecialchars(strip_tags($this->costprice));
			$this->saleprice		= htmlspecialchars(strip_tags($this->saleprice));
			$this->initial_qty		= htmlspecialchars(strip_tags($this->initial_qty));
			$this->editedby			= htmlspecialchars(strip_tags($this->editedby));

			//i represents an integer type
			//d represents an double type
			//s represents an string type including date
			//b represents an blob type
			$stmt->bind_param("ssssssssisiiiis", $this->wslocation, $this->rackno, $this->itemname, $this->itemdesc, $this->itemcatagory, $this->item_brand, $this->item_model, $this->partno, $this->qty_now, $this->part_unit, $this->minstocklevel, $this->costprice, $this->saleprice, $this->initial_qty, $this->editedby);

			if($stmt->execute()){
				return true;
			}		
		}
	}
	public function deleteRecord(){
		if($this->no) {
   			session_start(); 

			if ($_SESSION['userid'] == 'kadrichu@gmail.com')
			{
				$stmt = $this->conn->prepare("
					DELETE FROM ".$this->recordsTable." 
					WHERE no = ?");

				$this->no = htmlspecialchars(strip_tags($this->no));

				$stmt->bind_param("i", $this->no);

				if($stmt->execute()){
					return true;
				}
			}
		}
	}
}
?>